using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Text;
using System.Drawing;
using gov.va.med.vbecs.Common;

using System.Windows.Forms;


namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmNewEquipment
	/// </summary>
	public class FrmNewEquipment : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private bool _isLoading = false;

		#region Form Controls
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.Button btnClear;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnAdd;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.ColumnHeader columnHeader5;
		private System.Windows.Forms.ColumnHeader columnHeader6;
		private System.Windows.Forms.ColumnHeader columnHeader7;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox picEquipment;
		private System.Windows.Forms.GroupBox grpNewEquipment;
		private System.Windows.Forms.DateTimePicker dtpExpirationDate;
		private System.Windows.Forms.Label lblContractNumber;
		private System.Windows.Forms.GroupBox grpEquipment;
		private System.Windows.Forms.DateTimePicker dtpDateReceived;
		private System.Windows.Forms.TextBox txtEquipmentName;
		private System.Windows.Forms.Label lblEquipmentName;
		private System.Windows.Forms.Label lblDateReceived;
		private System.Windows.Forms.GroupBox grpManufacturer;
		private System.Windows.Forms.Label lblManufacturerName;
		private System.Windows.Forms.Label lblEquipmentType;
		private System.Windows.Forms.GroupBox grpInventory;
		private System.Windows.Forms.ListView lvInventory;
		private gov.va.med.vbecs.GUI.controls.MaskedTextBox mtxtPhone;
		private System.Windows.Forms.Label lblPhone;
		private System.Windows.Forms.Label lblAddress;
		private System.Windows.Forms.Label lblCity;
		private System.Windows.Forms.Label lblState;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbState;
		private gov.va.med.vbecs.GUI.controls.MaskedTextBox mtxtZip;
		private System.Windows.Forms.Label lblZip;
		private System.Windows.Forms.GroupBox grpInstallation;
		private System.Windows.Forms.CheckBox cbExpirationDate;
		private System.ComponentModel.IContainer components = null;
		private BOL.Equipment _equipment = null;
		private System.Windows.Forms.Label lblSerialNumber;
		private System.Windows.Forms.TextBox txtEquipmentID;
		private System.Windows.Forms.Label lblEquipmentID;
		private System.Windows.Forms.TextBox txtAddressLine2;
		private System.Windows.Forms.TextBox txtSerialNumber;
		private System.Windows.Forms.TextBox txtContractNumber;
		private System.Windows.Forms.TextBox txtAddressLine1;
		private System.Windows.Forms.TextBox txtCity;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbEquipmentType;
		private System.Windows.Forms.Button btnAddress;
		private System.Windows.Forms.Label label1;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbManufacturerName;

		#endregion

		#region Constructors/Dispose

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmNewEquipment()
		{
			InitializeComponent();
			//
			this._equipment = new BOL.Equipment(Guid.NewGuid());
			this._equipment.SetInitialBrokenRules(this.Name,Common.VbecsTables.Equipment.TableName);
			this._equipment.Invalid += new System.EventHandler(CheckValid);
			this._equipment.Valid += new System.EventHandler(CheckValid);
			this._equipment.IsDirtyChanged += new System.EventHandler(CheckValid);
			this._equipment.ManufacturerAddress.SetInitialBrokenRules(this.Name,Common.VbecsTables.Address.TableName);
			this._equipment.ManufacturerAddress.Invalid += new System.EventHandler(CheckValid);
			this._equipment.ManufacturerAddress.Valid += new System.EventHandler(CheckValid);
			this._equipment.ManufacturerAddress.IsDirtyChanged += new System.EventHandler(CheckValid);
			//
			SetComponentProperties();
			//
			this.IsDirty = false;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmNewEquipment));
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.picEquipment = new System.Windows.Forms.PictureBox();
            this.grpNewEquipment = new System.Windows.Forms.GroupBox();
            this.btnClear = new System.Windows.Forms.Button();
            this.btnAdd = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.grpInstallation = new System.Windows.Forms.GroupBox();
            this.dtpExpirationDate = new System.Windows.Forms.DateTimePicker();
            this.txtContractNumber = new System.Windows.Forms.TextBox();
            this.cbExpirationDate = new System.Windows.Forms.CheckBox();
            this.lblContractNumber = new System.Windows.Forms.Label();
            this.dtpDateReceived = new System.Windows.Forms.DateTimePicker();
            this.lblDateReceived = new System.Windows.Forms.Label();
            this.grpEquipment = new System.Windows.Forms.GroupBox();
            this.cmbEquipmentType = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.txtSerialNumber = new System.Windows.Forms.TextBox();
            this.txtEquipmentID = new System.Windows.Forms.TextBox();
            this.lblSerialNumber = new System.Windows.Forms.Label();
            this.txtEquipmentName = new System.Windows.Forms.TextBox();
            this.lblEquipmentName = new System.Windows.Forms.Label();
            this.lblEquipmentType = new System.Windows.Forms.Label();
            this.lblEquipmentID = new System.Windows.Forms.Label();
            this.grpManufacturer = new System.Windows.Forms.GroupBox();
            this.label1 = new System.Windows.Forms.Label();
            this.btnAddress = new System.Windows.Forms.Button();
            this.cmbManufacturerName = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.txtCity = new System.Windows.Forms.TextBox();
            this.txtAddressLine1 = new System.Windows.Forms.TextBox();
            this.txtAddressLine2 = new System.Windows.Forms.TextBox();
            this.lblZip = new System.Windows.Forms.Label();
            this.lblPhone = new System.Windows.Forms.Label();
            this.mtxtPhone = new gov.va.med.vbecs.GUI.controls.MaskedTextBox();
            this.mtxtZip = new gov.va.med.vbecs.GUI.controls.MaskedTextBox();
            this.cmbState = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.lblState = new System.Windows.Forms.Label();
            this.lblCity = new System.Windows.Forms.Label();
            this.lblAddress = new System.Windows.Forms.Label();
            this.lblManufacturerName = new System.Windows.Forms.Label();
            this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.btnCancel = new System.Windows.Forms.Button();
            this.grpInventory = new System.Windows.Forms.GroupBox();
            this.lvInventory = new System.Windows.Forms.ListView();
            this.columnHeader1 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader4 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader5 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader2 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader3 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader6 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader7 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picEquipment)).BeginInit();
            this.grpNewEquipment.SuspendLayout();
            this.grpInstallation.SuspendLayout();
            this.grpEquipment.SuspendLayout();
            this.grpManufacturer.SuspendLayout();
            this.grpInventory.SuspendLayout();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(692, 30);
            this.vbecsLogo1.TabIndex = 4;
            this.vbecsLogo1.Title = "Log In Equipment";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 409);
            this.lblRequiredField.TabIndex = 6;
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.picEquipment);
            this.grpImage.Location = new System.Drawing.Point(4, 32);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(52, 351);
            this.grpImage.TabIndex = 5;
            this.grpImage.TabStop = false;
            // 
            // picEquipment
            // 
            this.picEquipment.Image = ((System.Drawing.Image)(resources.GetObject("picEquipment.Image")));
            this.picEquipment.Location = new System.Drawing.Point(4, 12);
            this.picEquipment.Name = "picEquipment";
            this.picEquipment.Size = new System.Drawing.Size(45, 44);
            this.picEquipment.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.picEquipment.TabIndex = 0;
            this.picEquipment.TabStop = false;
            // 
            // grpNewEquipment
            // 
            this.grpNewEquipment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpNewEquipment.Controls.Add(this.btnClear);
            this.grpNewEquipment.Controls.Add(this.btnAdd);
            this.grpNewEquipment.Controls.Add(this.grpInstallation);
            this.grpNewEquipment.Controls.Add(this.grpEquipment);
            this.grpNewEquipment.Controls.Add(this.grpManufacturer);
            this.grpNewEquipment.Location = new System.Drawing.Point(60, 32);
            this.grpNewEquipment.Name = "grpNewEquipment";
            this.grpNewEquipment.Size = new System.Drawing.Size(626, 232);
            this.grpNewEquipment.TabIndex = 0;
            this.grpNewEquipment.TabStop = false;
            // 
            // btnClear
            // 
            this.btnClear.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnClear.CausesValidation = false;
            this.btnClear.Location = new System.Drawing.Point(544, 200);
            this.btnClear.Name = "btnClear";
            this.btnClear.Size = new System.Drawing.Size(75, 23);
            this.btnClear.TabIndex = 4;
            this.btnClear.Text = "C&lear";
            this.btnClear.Click += new System.EventHandler(this.ClearClick);
            // 
            // btnAdd
            // 
            this.btnAdd.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnAdd.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnAdd.Image = ((System.Drawing.Image)(resources.GetObject("btnAdd.Image")));
            this.btnAdd.Location = new System.Drawing.Point(464, 200);
            this.btnAdd.Name = "btnAdd";
            this.btnAdd.Size = new System.Drawing.Size(75, 23);
            this.btnAdd.TabIndex = 3;
            this.btnAdd.Click += new System.EventHandler(this.AddClick);
            this.btnAdd.MouseHover += new System.EventHandler(this.AddHover);
            // 
            // grpInstallation
            // 
            this.grpInstallation.AccessibleDescription = "Installation Information";
            this.grpInstallation.AccessibleName = "Installation Information";
            this.grpInstallation.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpInstallation.Controls.Add(this.dtpExpirationDate);
            this.grpInstallation.Controls.Add(this.txtContractNumber);
            this.grpInstallation.Controls.Add(this.cbExpirationDate);
            this.grpInstallation.Controls.Add(this.lblContractNumber);
            this.grpInstallation.Controls.Add(this.dtpDateReceived);
            this.grpInstallation.Controls.Add(this.lblDateReceived);
            this.grpInstallation.Location = new System.Drawing.Point(8, 132);
            this.grpInstallation.Name = "grpInstallation";
            this.grpInstallation.Size = new System.Drawing.Size(292, 92);
            this.grpInstallation.TabIndex = 1;
            this.grpInstallation.TabStop = false;
            this.grpInstallation.Text = "Installation Info";
            // 
            // dtpExpirationDate
            // 
            this.dtpExpirationDate.AccessibleDescription = "Expiration Renewal Date";
            this.dtpExpirationDate.AccessibleName = "Expiration Renewal Date";
            this.dtpExpirationDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.dtpExpirationDate.CustomFormat = "";
            this.dtpExpirationDate.Enabled = false;
            this.dtpExpirationDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
            this.dtpExpirationDate.Location = new System.Drawing.Point(160, 64);
            this.dtpExpirationDate.Name = "dtpExpirationDate";
            this.dtpExpirationDate.Size = new System.Drawing.Size(120, 20);
            this.dtpExpirationDate.TabIndex = 5;
            this.dtpExpirationDate.CloseUp += new System.EventHandler(this.dtpExpirationDate_ValueChanged);
            this.dtpExpirationDate.ValueChanged += new System.EventHandler(this.dtpExpirationDate_ValueChanged);
            // 
            // txtContractNumber
            // 
            this.txtContractNumber.AccessibleDescription = "Warranty Service Contract Number";
            this.txtContractNumber.AccessibleName = "Warranty Service Contract Number";
            this.txtContractNumber.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtContractNumber.Location = new System.Drawing.Point(160, 40);
            this.txtContractNumber.MaxLength = 25;
            this.txtContractNumber.Name = "txtContractNumber";
            this.txtContractNumber.Size = new System.Drawing.Size(120, 20);
            this.txtContractNumber.TabIndex = 3;
            this.txtContractNumber.TextChanged += new System.EventHandler(this.txtContractNumber_TextChanged);
            // 
            // cbExpirationDate
            // 
            this.cbExpirationDate.AccessibleDescription = "Expiration Renewal Date";
            this.cbExpirationDate.AccessibleName = "Expiration Renewal Date";
            this.cbExpirationDate.Location = new System.Drawing.Point(8, 64);
            this.cbExpirationDate.Name = "cbExpirationDate";
            this.cbExpirationDate.Size = new System.Drawing.Size(156, 20);
            this.cbExpirationDate.TabIndex = 4;
            this.cbExpirationDate.Text = "E&xpiration/Renewal Date";
            this.cbExpirationDate.CheckedChanged += new System.EventHandler(this.ExpirationCheckChanged);
            // 
            // lblContractNumber
            // 
            this.lblContractNumber.Location = new System.Drawing.Point(8, 40);
            this.lblContractNumber.Name = "lblContractNumber";
            this.lblContractNumber.Size = new System.Drawing.Size(160, 20);
            this.lblContractNumber.TabIndex = 2;
            this.lblContractNumber.Text = "Warranty/Service Contract No.";
            this.lblContractNumber.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // dtpDateReceived
            // 
            this.dtpDateReceived.AccessibleDescription = "Date Received Installed";
            this.dtpDateReceived.AccessibleName = "Date Received Installed";
            this.dtpDateReceived.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.dtpDateReceived.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
            this.dtpDateReceived.Location = new System.Drawing.Point(160, 16);
            this.dtpDateReceived.Name = "dtpDateReceived";
            this.dtpDateReceived.Size = new System.Drawing.Size(120, 20);
            this.dtpDateReceived.TabIndex = 1;
            this.dtpDateReceived.ValueChanged += new System.EventHandler(this.dtpDateReceived_ValueChanged);
            // 
            // lblDateReceived
            // 
            this.lblDateReceived.Location = new System.Drawing.Point(8, 16);
            this.lblDateReceived.Name = "lblDateReceived";
            this.lblDateReceived.Size = new System.Drawing.Size(152, 20);
            this.lblDateReceived.TabIndex = 0;
            this.lblDateReceived.Text = "Date Received/Installed*";
            this.lblDateReceived.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // grpEquipment
            // 
            this.grpEquipment.AccessibleDescription = "Equipment Information";
            this.grpEquipment.AccessibleName = "Equipment Information";
            this.grpEquipment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpEquipment.Controls.Add(this.cmbEquipmentType);
            this.grpEquipment.Controls.Add(this.txtSerialNumber);
            this.grpEquipment.Controls.Add(this.txtEquipmentID);
            this.grpEquipment.Controls.Add(this.lblSerialNumber);
            this.grpEquipment.Controls.Add(this.txtEquipmentName);
            this.grpEquipment.Controls.Add(this.lblEquipmentName);
            this.grpEquipment.Controls.Add(this.lblEquipmentType);
            this.grpEquipment.Controls.Add(this.lblEquipmentID);
            this.grpEquipment.Location = new System.Drawing.Point(8, 8);
            this.grpEquipment.Name = "grpEquipment";
            this.grpEquipment.Size = new System.Drawing.Size(292, 120);
            this.grpEquipment.TabIndex = 0;
            this.grpEquipment.TabStop = false;
            this.grpEquipment.Text = "Equipment Info";
            // 
            // cmbEquipmentType
            // 
            this.cmbEquipmentType.AccessibleDescription = "Equipment Type";
            this.cmbEquipmentType.AccessibleName = "Equipment Type";
            this.cmbEquipmentType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbEquipmentType.Interval = 500;
            this.cmbEquipmentType.Location = new System.Drawing.Point(104, 88);
            this.cmbEquipmentType.LookupEnabled = false;
            this.cmbEquipmentType.MaxLength = 25;
            this.cmbEquipmentType.Name = "cmbEquipmentType";
            this.cmbEquipmentType.Size = new System.Drawing.Size(176, 22);
            this.cmbEquipmentType.TabIndex = 7;
            this.cmbEquipmentType.TextChanged += new System.EventHandler(this.txtEquipmentType_TextChanged);
            // 
            // txtSerialNumber
            // 
            this.txtSerialNumber.AccessibleDescription = "Serial Number";
            this.txtSerialNumber.AccessibleName = "Serial Number";
            this.txtSerialNumber.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtSerialNumber.Location = new System.Drawing.Point(104, 64);
            this.txtSerialNumber.MaxLength = 50;
            this.txtSerialNumber.Name = "txtSerialNumber";
            this.txtSerialNumber.Size = new System.Drawing.Size(176, 20);
            this.txtSerialNumber.TabIndex = 5;
            this.txtSerialNumber.TextChanged += new System.EventHandler(this.txtSerialNumber_TextChanged);
            // 
            // txtEquipmentID
            // 
            this.txtEquipmentID.AccessibleDescription = "Local Equipment I D ";
            this.txtEquipmentID.AccessibleName = "Local Equipment I D ";
            this.txtEquipmentID.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtEquipmentID.Location = new System.Drawing.Point(104, 40);
            this.txtEquipmentID.MaxLength = 25;
            this.txtEquipmentID.Name = "txtEquipmentID";
            this.txtEquipmentID.Size = new System.Drawing.Size(176, 20);
            this.txtEquipmentID.TabIndex = 3;
            this.txtEquipmentID.TextChanged += new System.EventHandler(this.txtEquipmentID_TextChanged);
            // 
            // lblSerialNumber
            // 
            this.lblSerialNumber.Location = new System.Drawing.Point(8, 64);
            this.lblSerialNumber.Name = "lblSerialNumber";
            this.lblSerialNumber.Size = new System.Drawing.Size(132, 20);
            this.lblSerialNumber.TabIndex = 4;
            this.lblSerialNumber.Text = "Serial Number*";
            this.lblSerialNumber.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtEquipmentName
            // 
            this.txtEquipmentName.AccessibleDescription = "Equipment Name";
            this.txtEquipmentName.AccessibleName = "Equipment Name";
            this.txtEquipmentName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtEquipmentName.Location = new System.Drawing.Point(104, 16);
            this.txtEquipmentName.MaxLength = 75;
            this.txtEquipmentName.Name = "txtEquipmentName";
            this.txtEquipmentName.Size = new System.Drawing.Size(176, 20);
            this.txtEquipmentName.TabIndex = 1;
            this.txtEquipmentName.TextChanged += new System.EventHandler(this.txtEquipmentName_TextChanged);
            // 
            // lblEquipmentName
            // 
            this.lblEquipmentName.Location = new System.Drawing.Point(8, 16);
            this.lblEquipmentName.Name = "lblEquipmentName";
            this.lblEquipmentName.Size = new System.Drawing.Size(108, 20);
            this.lblEquipmentName.TabIndex = 0;
            this.lblEquipmentName.Text = "Equipment Name*";
            this.lblEquipmentName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblEquipmentType
            // 
            this.lblEquipmentType.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblEquipmentType.Location = new System.Drawing.Point(8, 88);
            this.lblEquipmentType.Name = "lblEquipmentType";
            this.lblEquipmentType.Size = new System.Drawing.Size(108, 20);
            this.lblEquipmentType.TabIndex = 6;
            this.lblEquipmentType.Text = "Equipment Type*";
            this.lblEquipmentType.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblEquipmentID
            // 
            this.lblEquipmentID.Location = new System.Drawing.Point(8, 40);
            this.lblEquipmentID.Name = "lblEquipmentID";
            this.lblEquipmentID.Size = new System.Drawing.Size(132, 20);
            this.lblEquipmentID.TabIndex = 2;
            this.lblEquipmentID.Text = "Local Equipment ID";
            this.lblEquipmentID.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // grpManufacturer
            // 
            this.grpManufacturer.AccessibleDescription = "Manufacturer Information";
            this.grpManufacturer.AccessibleName = "Manufacturer Information";
            this.grpManufacturer.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.grpManufacturer.Controls.Add(this.label1);
            this.grpManufacturer.Controls.Add(this.btnAddress);
            this.grpManufacturer.Controls.Add(this.cmbManufacturerName);
            this.grpManufacturer.Controls.Add(this.txtCity);
            this.grpManufacturer.Controls.Add(this.txtAddressLine1);
            this.grpManufacturer.Controls.Add(this.txtAddressLine2);
            this.grpManufacturer.Controls.Add(this.lblZip);
            this.grpManufacturer.Controls.Add(this.lblPhone);
            this.grpManufacturer.Controls.Add(this.mtxtPhone);
            this.grpManufacturer.Controls.Add(this.mtxtZip);
            this.grpManufacturer.Controls.Add(this.cmbState);
            this.grpManufacturer.Controls.Add(this.lblState);
            this.grpManufacturer.Controls.Add(this.lblCity);
            this.grpManufacturer.Controls.Add(this.lblAddress);
            this.grpManufacturer.Controls.Add(this.lblManufacturerName);
            this.grpManufacturer.Location = new System.Drawing.Point(308, 8);
            this.grpManufacturer.Name = "grpManufacturer";
            this.grpManufacturer.Size = new System.Drawing.Size(310, 188);
            this.grpManufacturer.TabIndex = 2;
            this.grpManufacturer.TabStop = false;
            this.grpManufacturer.Text = "Manufacturer Info";
            // 
            // label1
            // 
            this.label1.Location = new System.Drawing.Point(8, 64);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(96, 20);
            this.label1.TabIndex = 14;
            this.label1.Text = "Address Line 2";
            this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // btnAddress
            // 
            this.btnAddress.AccessibleDescription = "find";
            this.btnAddress.AccessibleName = "find";
            this.btnAddress.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnAddress.Enabled = false;
            this.btnAddress.Font = new System.Drawing.Font("Arial", 5.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnAddress.Location = new System.Drawing.Point(278, 40);
            this.btnAddress.Name = "btnAddress";
            this.btnAddress.Size = new System.Drawing.Size(26, 22);
            this.btnAddress.TabIndex = 4;
            this.btnAddress.Text = "find";
            this.btnAddress.Click += new System.EventHandler(this.btnAddress_Click);
            // 
            // cmbManufacturerName
            // 
            this.cmbManufacturerName.AccessibleDescription = "Manufacturer Name";
            this.cmbManufacturerName.AccessibleName = "Manufacturer Name";
            this.cmbManufacturerName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbManufacturerName.Interval = 500;
            this.cmbManufacturerName.Location = new System.Drawing.Point(112, 16);
            this.cmbManufacturerName.LookupEnabled = false;
            this.cmbManufacturerName.MaxLength = 50;
            this.cmbManufacturerName.Name = "cmbManufacturerName";
            this.cmbManufacturerName.Size = new System.Drawing.Size(188, 22);
            this.cmbManufacturerName.TabIndex = 1;
            this.cmbManufacturerName.TextChanged += new System.EventHandler(this.txtManufacturerName_TextChanged);
            // 
            // txtCity
            // 
            this.txtCity.AccessibleDescription = "City";
            this.txtCity.AccessibleName = "City";
            this.txtCity.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtCity.Location = new System.Drawing.Point(112, 88);
            this.txtCity.MaxLength = 55;
            this.txtCity.Name = "txtCity";
            this.txtCity.Size = new System.Drawing.Size(188, 20);
            this.txtCity.TabIndex = 7;
            this.txtCity.TextChanged += new System.EventHandler(this.txtCity_TextChanged);
            // 
            // txtAddressLine1
            // 
            this.txtAddressLine1.AccessibleDescription = "Address Line 1";
            this.txtAddressLine1.AccessibleName = "Address Line 1";
            this.txtAddressLine1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtAddressLine1.Location = new System.Drawing.Point(112, 40);
            this.txtAddressLine1.MaxLength = 255;
            this.txtAddressLine1.Name = "txtAddressLine1";
            this.txtAddressLine1.Size = new System.Drawing.Size(166, 20);
            this.txtAddressLine1.TabIndex = 3;
            this.txtAddressLine1.TextChanged += new System.EventHandler(this.txtAddressLine1_TextChanged);
            // 
            // txtAddressLine2
            // 
            this.txtAddressLine2.AccessibleDescription = "Address Line 2";
            this.txtAddressLine2.AccessibleName = "Address Line 2";
            this.txtAddressLine2.Location = new System.Drawing.Point(112, 64);
            this.txtAddressLine2.MaxLength = 255;
            this.txtAddressLine2.Name = "txtAddressLine2";
            this.txtAddressLine2.Size = new System.Drawing.Size(188, 20);
            this.txtAddressLine2.TabIndex = 5;
            this.txtAddressLine2.TextChanged += new System.EventHandler(this.txtAddressLine2_TextChanged);
            // 
            // lblZip
            // 
            this.lblZip.Location = new System.Drawing.Point(8, 136);
            this.lblZip.Name = "lblZip";
            this.lblZip.Size = new System.Drawing.Size(104, 20);
            this.lblZip.TabIndex = 10;
            this.lblZip.Text = "Zip";
            this.lblZip.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblPhone
            // 
            this.lblPhone.Image = ((System.Drawing.Image)(resources.GetObject("lblPhone.Image")));
            this.lblPhone.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.lblPhone.Location = new System.Drawing.Point(8, 160);
            this.lblPhone.Name = "lblPhone";
            this.lblPhone.Size = new System.Drawing.Size(100, 20);
            this.lblPhone.TabIndex = 12;
            this.lblPhone.Text = "Phone";
            this.lblPhone.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // mtxtPhone
            // 
            this.mtxtPhone.AccessibleDescription = "Phone";
            this.mtxtPhone.AccessibleName = "Phone";
            this.mtxtPhone.ErrorMsg = "The phone number you have entered is invalid.";
            this.mtxtPhone.Location = new System.Drawing.Point(104, 160);
            this.mtxtPhone.Mask = "(###) ###-####";
            this.mtxtPhone.MaskType = gov.va.med.vbecs.GUI.controls.MaskTypeEnum.Phone;
            this.mtxtPhone.Name = "mtxtPhone";
            this.mtxtPhone.Size = new System.Drawing.Size(104, 24);
            this.mtxtPhone.TabIndex = 13;
            this.mtxtPhone.MaskedTextValidated += new System.EventHandler(this.ValidPhoneNumber);
            this.mtxtPhone.MaskedTextInvalidated += new System.EventHandler(this.InvalidPhoneNumber);
            this.mtxtPhone.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.KeyPressCheckDigit);
            // 
            // mtxtZip
            // 
            this.mtxtZip.AccessibleDescription = "Zip";
            this.mtxtZip.AccessibleName = "Zip";
            this.mtxtZip.ErrorMsg = null;
            this.mtxtZip.Location = new System.Drawing.Point(104, 136);
            this.mtxtZip.Mask = "#####-####";
            this.mtxtZip.MaskType = gov.va.med.vbecs.GUI.controls.MaskTypeEnum.Zip;
            this.mtxtZip.Name = "mtxtZip";
            this.mtxtZip.Size = new System.Drawing.Size(104, 24);
            this.mtxtZip.TabIndex = 11;
            this.mtxtZip.MaskedTextValidated += new System.EventHandler(this.ValidZipCode);
            this.mtxtZip.MaskedTextInvalidated += new System.EventHandler(this.InvalidZipCode);
            this.mtxtZip.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.KeyPressCheckDigit);
            // 
            // cmbState
            // 
            this.cmbState.AccessibleDescription = "State";
            this.cmbState.AccessibleName = "State";
            this.cmbState.Interval = 500;
            this.cmbState.Location = new System.Drawing.Point(112, 112);
            this.cmbState.MaxLength = 2;
            this.cmbState.Name = "cmbState";
            this.cmbState.Size = new System.Drawing.Size(88, 22);
            this.cmbState.TabIndex = 9;
            this.cmbState.SelectedIndexChanged += new System.EventHandler(this.cmbState_SelectedIndexChanged);
            this.cmbState.Leave += new System.EventHandler(this.cmbState_Leave);
            // 
            // lblState
            // 
            this.lblState.Location = new System.Drawing.Point(8, 112);
            this.lblState.Name = "lblState";
            this.lblState.Size = new System.Drawing.Size(96, 20);
            this.lblState.TabIndex = 8;
            this.lblState.Text = "State";
            this.lblState.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblCity
            // 
            this.lblCity.Location = new System.Drawing.Point(8, 88);
            this.lblCity.Name = "lblCity";
            this.lblCity.Size = new System.Drawing.Size(96, 20);
            this.lblCity.TabIndex = 6;
            this.lblCity.Text = "City";
            this.lblCity.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblAddress
            // 
            this.lblAddress.Location = new System.Drawing.Point(8, 40);
            this.lblAddress.Name = "lblAddress";
            this.lblAddress.Size = new System.Drawing.Size(96, 20);
            this.lblAddress.TabIndex = 2;
            this.lblAddress.Text = "Address Line 1";
            this.lblAddress.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblManufacturerName
            // 
            this.lblManufacturerName.Location = new System.Drawing.Point(8, 16);
            this.lblManufacturerName.Name = "lblManufacturerName";
            this.lblManufacturerName.Size = new System.Drawing.Size(112, 20);
            this.lblManufacturerName.TabIndex = 0;
            this.lblManufacturerName.Text = "Manufacturer Name*";
            this.lblManufacturerName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // btnOK
            // 
            this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
            this.btnOK.Location = new System.Drawing.Point(532, 387);
            this.btnOK.Name = "btnOK";
            this.btnOK.Size = new System.Drawing.Size(75, 23);
            this.btnOK.TabIndex = 2;
            this.btnOK.Click += new System.EventHandler(this.OKClick);
            this.btnOK.MouseHover += new System.EventHandler(this.btnOK_MouseHover);
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.CausesValidation = false;
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(612, 387);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 3;
            this.btnCancel.Text = "&Cancel";
            this.btnCancel.Click += new System.EventHandler(this.CancelClick);
            // 
            // grpInventory
            // 
            this.grpInventory.AccessibleDescription = "Equipment Logged In";
            this.grpInventory.AccessibleName = "Equipment Logged In";
            this.grpInventory.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpInventory.Controls.Add(this.lvInventory);
            this.grpInventory.Location = new System.Drawing.Point(60, 268);
            this.grpInventory.Name = "grpInventory";
            this.grpInventory.Size = new System.Drawing.Size(626, 114);
            this.grpInventory.TabIndex = 1;
            this.grpInventory.TabStop = false;
            this.grpInventory.Text = "Equipment Logged In";
            // 
            // lvInventory
            // 
            this.lvInventory.AccessibleDescription = "Equipment Logged In";
            this.lvInventory.AccessibleName = "Equipment Logged In";
            this.lvInventory.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvInventory.CheckBoxes = true;
            this.lvInventory.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader1,
            this.columnHeader4,
            this.columnHeader5,
            this.columnHeader2,
            this.columnHeader3,
            this.columnHeader6,
            this.columnHeader7});
            this.lvInventory.FullRowSelect = true;
            this.lvInventory.HideSelection = false;
            this.lvInventory.Location = new System.Drawing.Point(8, 16);
            this.lvInventory.MultiSelect = false;
            this.lvInventory.Name = "lvInventory";
            this.lvInventory.Size = new System.Drawing.Size(610, 90);
            this.lvInventory.TabIndex = 0;
            this.lvInventory.UseCompatibleStateImageBehavior = false;
            this.lvInventory.View = System.Windows.Forms.View.Details;
            this.lvInventory.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvInventory_ColumnClick);
            this.lvInventory.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvInventory_ItemCheck);
            this.lvInventory.SelectedIndexChanged += new System.EventHandler(this.lvInventory_SelectedIndexChanged);
            // 
            // columnHeader1
            // 
            this.columnHeader1.Text = "";
            this.columnHeader1.Width = 25;
            // 
            // columnHeader4
            // 
            this.columnHeader4.Text = "Equipment Name";
            this.columnHeader4.Width = 100;
            // 
            // columnHeader5
            // 
            this.columnHeader5.Text = "Serial No.";
            this.columnHeader5.Width = 80;
            // 
            // columnHeader2
            // 
            this.columnHeader2.Text = "Type";
            this.columnHeader2.Width = 80;
            // 
            // columnHeader3
            // 
            this.columnHeader3.Text = "Manufacturer";
            this.columnHeader3.Width = 150;
            // 
            // columnHeader6
            // 
            this.columnHeader6.Text = "Received";
            this.columnHeader6.Width = 80;
            // 
            // columnHeader7
            // 
            this.columnHeader7.Text = "Contract No.";
            this.columnHeader7.Width = 80;
            // 
            // FrmNewEquipment
            // 
            this.AcceptButton = this.btnAdd;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(692, 423);
            this.Controls.Add(this.grpInventory);
            this.Controls.Add(this.btnOK);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.grpNewEquipment);
            this.Controls.Add(this.grpImage);
            this.hlphelpChm.SetHelpKeyword(this, "Maintain_Equipment.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(660, 450);
            this.Name = "FrmNewEquipment";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Log In Equipment";
            this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmNewEquipment_KeyDownSpeakMessage);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.grpNewEquipment, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.btnOK, 0);
            this.Controls.SetChildIndex(this.grpInventory, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpImage.ResumeLayout(false);
            this.grpImage.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picEquipment)).EndInit();
            this.grpNewEquipment.ResumeLayout(false);
            this.grpInstallation.ResumeLayout(false);
            this.grpInstallation.PerformLayout();
            this.grpEquipment.ResumeLayout(false);
            this.grpEquipment.PerformLayout();
            this.grpManufacturer.ResumeLayout(false);
            this.grpManufacturer.PerformLayout();
            this.grpInventory.ResumeLayout(false);
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		#region Methods
		private void SetComponentProperties()
		{
			this._isLoading = true;

			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC022.FrmLoginEquipment());
			//
			this.btnAdd.EnabledButton = false;
			this.btnAdd.Text = "&Add";
			//
			this.btnOK.EnabledButton = false;
			this.btnOK.Text = "&OK";

			this.SetToolTips();
			//
			

			//set custom date and time format
			this.dtpExpirationDate.CustomFormat = " ";
			this.dtpDateReceived.CustomFormat = Common.VBECSDateTime.DateTimeFormat;

			//set current date value based on the division time zone
			System.DateTime _currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.dtpExpirationDate.Value = _currentDate.Date.AddHours(23).AddMinutes(59);
			this.dtpDateReceived.Value = _currentDate;
			this.dtpDateReceived.MaxDate = _currentDate;
			//
			this.cmbEquipmentType.LookupEnabled = false;
			this.cmbManufacturerName.LookupEnabled = false;
			//
			this.LoadStates();
			//
			this.LoadEquipmentTypes();
			//
			this.LoadManufacturerNames();

			this._isLoading = false;
		}

		private void SetToolTips()
		{
			this.SetThisToolTip(this.txtEquipmentName, Common.StrRes.Tooltips.UC022.EquipmentName());
			this.SetThisToolTip(this.txtEquipmentID, Common.StrRes.Tooltips.UC022.LocalEquipmentId());
			this.SetThisToolTip(this.txtSerialNumber, Common.StrRes.Tooltips.UC022.SerialNumber());
			this.SetThisToolTip(this.cmbEquipmentType, Common.StrRes.Tooltips.UC022.EquipmentType());
			this.SetThisToolTip(this.dtpDateReceived, Common.StrRes.Tooltips.UC022.DateReceivedInstalled());
			this.SetThisToolTip(this.txtContractNumber, Common.StrRes.Tooltips.UC022.WarrantyServiceContractNumber());
			this.SetThisToolTip(this.cbExpirationDate, Common.StrRes.Tooltips.UC022.ExpirationRenewalDateOnOff());
			this.SetThisToolTip(this.dtpExpirationDate, Common.StrRes.Tooltips.UC022.ExpirationRenewalDate());
			//
			this.SetThisToolTip(this.cmbManufacturerName, Common.StrRes.Tooltips.Common.ManufacturerName());
			this.SetThisToolTip(this.txtAddressLine1, Common.StrRes.Tooltips.Common.ManufacturerAddress1());
			this.SetThisToolTip(this.txtAddressLine2, Common.StrRes.Tooltips.Common.ManufacturerAddress2());
			this.SetThisToolTip(this.txtCity, Common.StrRes.Tooltips.Common.ManufacturerCity());
			this.SetThisToolTip(this.cmbState, Common.StrRes.Tooltips.Common.ManufacturerState());
			this.mtxtZip.SetToolTip(Common.StrRes.Tooltips.Common.ManufacturerZip());
			this.mtxtPhone.SetToolTip(Common.StrRes.Tooltips.Common.ManufacturerPhone());
			this.SetThisToolTip(this.btnAddress, Common.StrRes.Tooltips.UC022.AddressSelect());
			//
			this.SetThisToolTip(btnClear,Common.StrRes.Tooltips.Common.ClearEntries());
			//
			this.SetThisToolTip(this.lvInventory, Common.StrRes.Tooltips.UC022.EquipmentLoggedIn());
			//
			this.SetThisToolTip(btnCancel,Common.StrRes.Tooltips.Common.Cancel());
		}

		private void LoadStates()
		{
			cmbState.Items.Clear();
			cmbState.Items.AddRange(BOL.ReferenceData.GetStateCodes());
		}

		private void LoadEquipmentTypes()
		{
			ArrayList equipmentTypes = BOL.Equipment.GetEquipmentTypes();
			//
			cmbEquipmentType.Items.Clear();
			foreach(string equip in equipmentTypes)
			{
				cmbEquipmentType.Items.Add(equip);
			}
		}

		private void LoadManufacturerNames()
		{
			ArrayList manufacturers = BOL.Equipment.GetEquipmentManufacturerNames();
			//
			cmbManufacturerName.Items.Clear();
			foreach(string mfr in manufacturers)
			{
				cmbManufacturerName.Items.Add(mfr);
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		private string GetAddButtonToolTip()
		{
			string message = string.Empty;
			//
			if ((this._equipment.IsValid)&&(this._equipment.ManufacturerAddress.IsValid))
			{
				if (this.btnAdd.Text == "&Add")
				{
					message = Common.StrRes.Tooltips.UC022.AddEquipment().ResString;
				}
				else
				{
					if (this._equipment.IsDirty || this._equipment.ManufacturerAddress.IsDirty)
					{
						message = Common.StrRes.Tooltips.UC022.UpdateEquipment().ResString;
					}
					else
					{
						message = Common.StrRes.Tooltips.Common.NoChangesToAddOrUpdate().ResString;
					}
				}
			}
			else
			{
				message = string.Concat(this._equipment.GetBrokenRulesMessage(this.Name), "\n", this._equipment.ManufacturerAddress.GetBrokenRulesMessage(this.Name));
			}
			//
			return message;
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		private string GetOKButtonToolTip()
		{
			string message = string.Empty;
			//
			if (this.btnOK.EnabledButton)
			{
				message = Common.StrRes.Tooltips.Common.OKToSave().ResString;
			}
			else
			{
				message = Common.StrRes.Tooltips.Common.CheckOneItem("equipment").ResString;
			}
			//
			return message;
		}

		#endregion

		#region Events / Event Handlers

		private void CheckValid(object sender, System.EventArgs e)
		{
			if (this._equipment.IsValid && this._equipment.ManufacturerAddress.IsValid)
			{
				if (this._equipment.IsDirty || this._equipment.ManufacturerAddress.IsDirty)
				{
					this.btnAdd.EnabledButton = true;
				}
				else
				{
					this.btnAdd.EnabledButton = false;
				}
			}
			else
			{
				this.btnAdd.EnabledButton = false;
			}
		}

		private void lvInventory_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if (e.Column == 5)
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvInventory.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.DateTime);
			}
			else
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvInventory.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.String);
			}
		}

		private void txtContractNumber_TextChanged(object sender, System.EventArgs e)
		{
			if(this._equipment != null)
			{
				this._equipment.MaintenanceContractNumber = txtContractNumber.Text;
				this.IsDirty = true;
			}
		}

		private void txtEquipmentName_TextChanged(object sender, System.EventArgs e)
		{
			if(this._equipment != null)
			{
				this._equipment.EquipmentName = txtEquipmentName.Text;
				this.IsDirty = true;
			}
		}

		private void txtEquipmentID_TextChanged(object sender, System.EventArgs e)
		{
			if(this._equipment != null)
			{
				this._equipment.LocalIdentifier = txtEquipmentID.Text;
				this.IsDirty = true;
			}
		}

		private void txtSerialNumber_TextChanged(object sender, System.EventArgs e)
		{
			if(this._equipment != null)
			{
				this._equipment.SerialNumber = txtSerialNumber.Text;
				this.IsDirty = true;
			}
		}

		private void txtEquipmentType_TextChanged(object sender, System.EventArgs e)
		{
			if(this._equipment != null)
			{
				this._equipment.EquipmentType = cmbEquipmentType.Text;
				this.IsDirty = true;
			}
		}

		private void dtpDateReceived_ValueChanged(object sender, System.EventArgs e)
		{
			if(this._equipment != null)
			{
				this._equipment.ReceiptDate = dtpDateReceived.Value;
				this.IsDirty = true;
			}
		}

		private void dtpExpirationDate_ValueChanged(object sender, System.EventArgs e)
		{
			if(this._equipment != null && !this._isLoading)
			{
				this._equipment.MaintenanceContractDate = dtpExpirationDate.Value;
				this.IsDirty = true;
			}
		}

		private void txtManufacturerName_TextChanged(object sender, System.EventArgs e)
		{
			if(this._equipment != null)
			{
				this._equipment.ManufacturerName = cmbManufacturerName.Text;
				this.IsDirty = true;
			}
			//
			this.btnAddress.Enabled = (this.cmbManufacturerName.Text.Trim().Length>0);
		}

		private void txtAddressLine1_TextChanged(object sender, System.EventArgs e)
		{
			if(this._equipment != null)
			{
				this._equipment.ManufacturerAddress.AddressLine1 = txtAddressLine1.Text;
				this.IsDirty = true;
			}
		}
		
		private void txtAddressLine2_TextChanged(object sender, System.EventArgs e)
		{
			if(this._equipment != null)
			{
				this._equipment.ManufacturerAddress.AddressLine2 = txtAddressLine2.Text;
				this.IsDirty = true;
			}
		}

		private void txtCity_TextChanged(object sender, System.EventArgs e)
		{
			if(this._equipment != null)
			{
				this._equipment.ManufacturerAddress.City = txtCity.Text;
				this.IsDirty = true;
			}
		}
		
		private void cmbState_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(this._equipment != null)
			{
				if (this.cmbState.SelectedIndex>-1)
				{
					this._equipment.ManufacturerAddress.StateCode = cmbState.Text;
				}
				else
				{
					this._equipment.ManufacturerAddress.StateCode = "";
				}
				this.IsDirty = true;
			}
		}


		private void ValidZipCode(object sender, System.EventArgs e)
		{
			if (this._equipment != null)
			{
				try
				{
					this._equipment.ManufacturerAddress.ZipCode = this.mtxtZip.GetText();
					this.errError.SetVbecsError(this.mtxtZip, string.Empty); // **** 508 Compliance ***
					this.IsDirty = true;
				}
				catch(BOL.BusinessObjectException err)
				{
					this.errError.SetVbecsError(this.mtxtZip, err.Message); // **** 508 Compliance ***
				}
			}
		}

		private void InvalidZipCode(object sender, System.EventArgs e)
		{
			if (this._equipment != null)
			{
				this._equipment.ManufacturerAddress.ZipCode = "";
				this.IsDirty = true;
				this.errError.SetVbecsError(this.mtxtZip, string.Empty); // **** 508 Compliance ***
			}
		}

		private void InvalidPhoneNumber(object sender, System.EventArgs e)
		{
			if (this._equipment != null)
			{
				this._equipment.ManufacturerPhoneNumber = "";
				this.IsDirty = true;
			}
		}

		private void ValidPhoneNumber(object sender, System.EventArgs e)
		{
			if (this._equipment != null)
			{
				this._equipment.ManufacturerPhoneNumber = this.mtxtPhone.GetText();
				this.IsDirty = true;
			}
		}

		private void ExpirationCheckChanged(object sender, System.EventArgs e)
		{
			if (this._equipment != null)
			{
				if (this.cbExpirationDate.Checked)
				{
					this._equipment.IsMaintenanceContractDate = true;
					this._equipment.MaintenanceContractDate = this.dtpExpirationDate.Value;
					this.dtpExpirationDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;
					this.dtpExpirationDate.Enabled = true;
					this.cbExpirationDate.Text = "Expiration/Renewal Date*";
					this.IsDirty = true;
				}
				else
				{
					this._equipment.IsMaintenanceContractDate = false;
					this._equipment.MaintenanceContractDate = DateTime.MinValue;
					this.dtpExpirationDate.CustomFormat = " ";
					this.dtpExpirationDate.Enabled = false;
					this.cbExpirationDate.Text = "Expiration/Renewal Date";
					this.IsDirty = true;
				}
			}
		}

		private void ClearClick(object sender, System.EventArgs e)
		{
			this.errError.SetVbecsError(this.mtxtZip, string.Empty); // **** 508 Compliance ***

			this._equipment = new BOL.Equipment(Guid.NewGuid());
			this._equipment.SetInitialBrokenRules(this.Name,Common.VbecsTables.Equipment.TableName);
			this._equipment.Invalid += new System.EventHandler(CheckValid);
			this._equipment.Valid += new System.EventHandler(CheckValid);
			this._equipment.IsDirtyChanged += new System.EventHandler(CheckValid);
			this._equipment.ManufacturerAddress.SetInitialBrokenRules(this.Name,Common.VbecsTables.Address.TableName);
			this._equipment.ManufacturerAddress.Invalid += new System.EventHandler(CheckValid);
			this._equipment.ManufacturerAddress.Valid += new System.EventHandler(CheckValid);
			this._equipment.ManufacturerAddress.IsDirtyChanged += new System.EventHandler(CheckValid);
			//
			this._isLoading = true;
			this.txtSerialNumber.Text = "";
			this.txtEquipmentID.Text = "";
			this.txtEquipmentName.Text = "";
			this.cmbEquipmentType.Text = "";
			this.cmbEquipmentType.SelectedIndex = -1;
			System.DateTime currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.dtpDateReceived.MaxDate = currentDate;
			this.dtpDateReceived.Value = currentDate;
			this.txtContractNumber.Text = "";
			this.cbExpirationDate.Checked = false;
			this.dtpExpirationDate.Value = currentDate.Date.AddHours(23).AddMinutes(59);
			this.cmbManufacturerName.Text = "";
			this.cmbManufacturerName.SelectedIndex = -1;
			this.txtAddressLine1.Text = "";
			this.txtAddressLine2.Text = "";
			this.txtCity.Text = "";
			this.cmbState.SelectedIndex = -1;
			this.mtxtZip.SetText("");
			this.mtxtPhone.SetText("");
			this._isLoading = false;
			//
			this.btnAdd.Text = "&Add";
			//
			this.lvInventory.SelectedItems.Clear();
		}

		private void AddClick(object sender, System.EventArgs e)
		{
			Guid checkDuplicateGuid = BOL.Equipment.GetEquipmentBySerialNumberAndManufacturer(this._equipment.SerialNumber,this._equipment.ManufacturerName);
			//
			if (checkDuplicateGuid != Guid.Empty)
			{
				//We have a duplicate!!
				if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC022.MaintainExistingEquipment())==DialogResult.Yes)
				{
					FrmMaintainEquipment frm = new FrmMaintainEquipment(checkDuplicateGuid);
					frm.ShowDialog(this.MdiParent);
					ClearClick(sender,e);
					return;
				}
				else
				{
					return;
				}
			}
			//
			bool isNew = true;
			foreach(ListViewItem lviSearch in this.lvInventory.Items)
			{
				if (((BOL.Equipment)lviSearch.Tag).EquipmentGuid == this._equipment.EquipmentGuid)
				{
					lviSearch.Checked = true;
					lviSearch.Tag = this._equipment;
					lviSearch.SubItems[1].Text = this._equipment.EquipmentName;
					lviSearch.SubItems[2].Text = this._equipment.SerialNumber;
					lviSearch.SubItems[3].Text = this._equipment.EquipmentType;
					lviSearch.SubItems[4].Text = this._equipment.ManufacturerName;
					lviSearch.SubItems[5].Text = Common.VBECSDateTime.FormatDateTimeString(this._equipment.ReceiptDate);
					lviSearch.SubItems[6].Text = this._equipment.MaintenanceContractNumber;
					isNew = false;
					break;
				}
			}
			//
			if (isNew)
			{
				ListViewItem lvi = new ListViewItem();
				lvi.Checked = true;
				lvi.Tag = this._equipment;
				lvi.SubItems.Add(this._equipment.EquipmentName);
				lvi.SubItems.Add(this._equipment.SerialNumber);
				lvi.SubItems.Add(this._equipment.EquipmentType);
				lvi.SubItems.Add(this._equipment.ManufacturerName);
				lvi.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(this._equipment.ReceiptDate));
				lvi.SubItems.Add(this._equipment.MaintenanceContractNumber);
				this.lvInventory.Items.Add(lvi);
			}
			//
			controls.VbecsFunction.SetColumnWidths(this.lvInventory);
			//
			this.ClearClick(sender,e);
			//
			this.btnOK.EnabledButton = (this.lvInventory.CheckedItems.Count>0);
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void AddHover(object sender, System.EventArgs e)
		{
			this.btnAdd.SetToolTip( GetAddButtonToolTip() );
		}

		private BOL.Equipment CloneEquipment(BOL.Equipment equipment)
		{
			//
			//Aargh. This is a hack. The Clone method doesn't do what I need.
			//If they select an item in the list view, any changes should not be
			//updated in the tag of the listviewitem unitl they click Update. So
			//we need a copy of the object.
			//
			BOL.Equipment clone = new BOL.Equipment(equipment.EquipmentGuid);
			clone.EquipmentName = equipment.EquipmentName;
			clone.EquipmentType = equipment.EquipmentType;
			clone.InspectionIndicator = equipment.InspectionIndicator;
			clone.InvoiceNumber = equipment.InvoiceNumber;
			clone.IsMaintenanceContractDate = equipment.IsMaintenanceContractDate;
			clone.LocalIdentifier = equipment.LocalIdentifier;
			clone.MaintenanceContractDate = equipment.MaintenanceContractDate;
			clone.MaintenanceContractNumber = equipment.MaintenanceContractNumber;
			clone.ManufacturerName = equipment.ManufacturerName;
			clone.ManufacturerPhoneNumber = equipment.ManufacturerPhoneNumber;
			clone.ReceiptDate = equipment.ReceiptDate;
			clone.ReceiptTechId = equipment.ReceiptTechId;
			clone.SerialNumber = equipment.SerialNumber;
			clone.IsNew = equipment.IsNew;
			clone.RowVersion = equipment.RowVersion;
			//
			clone.ManufacturerAddress.AddressGuid = equipment.ManufacturerAddress.AddressGuid;
			clone.ManufacturerAddress.AddressLine1 = equipment.ManufacturerAddress.AddressLine1;
			clone.ManufacturerAddress.AddressLine2 = equipment.ManufacturerAddress.AddressLine2;
			clone.ManufacturerAddress.City = equipment.ManufacturerAddress.City;
			clone.ManufacturerAddress.StateCode = equipment.ManufacturerAddress.StateCode;
			clone.ManufacturerAddress.ZipCode = equipment.ManufacturerAddress.ZipCode;
			clone.ManufacturerAddress.IsNew = equipment.ManufacturerAddress.IsNew;
			clone.ManufacturerAddress.RowVersion = equipment.ManufacturerAddress.RowVersion;
			//
			clone.ManufacturerAddress.IsDirty = false;
			clone.IsDirty = false;
			//
			return clone;
		}

		private void lvInventory_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (this.lvInventory.SelectedItems.Count>0)
			{
				BOL.Equipment equipment = (BOL.Equipment)this.lvInventory.SelectedItems[0].Tag;
				//
				
				this._equipment = CloneEquipment(equipment);
				this._equipment.SetInitialBrokenRules(this.Name,Common.VbecsTables.Equipment.TableName);
				this._equipment.Invalid += new System.EventHandler(CheckValid);
				this._equipment.Valid += new System.EventHandler(CheckValid);
				this._equipment.IsDirtyChanged += new System.EventHandler(CheckValid);
				this._equipment.ManufacturerAddress.SetInitialBrokenRules(this.Name,Common.VbecsTables.Address.TableName);
				this._equipment.ManufacturerAddress.Invalid += new System.EventHandler(CheckValid);
				this._equipment.ManufacturerAddress.Valid += new System.EventHandler(CheckValid);
				this._equipment.ManufacturerAddress.IsDirtyChanged += new System.EventHandler(CheckValid);
				//
				this.txtEquipmentID.Text = equipment.LocalIdentifier;
				this.txtSerialNumber.Text = equipment.SerialNumber;
				this.txtEquipmentName.Text = equipment.EquipmentName;
				this.cmbEquipmentType.Text = equipment.EquipmentType;
				System.DateTime currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
				this.dtpDateReceived.MaxDate = currentDate;
				this.dtpDateReceived.Value = equipment.ReceiptDate;
				this.txtContractNumber.Text = equipment.MaintenanceContractNumber;
				//
				if (this._equipment.IsMaintenanceContractDate)
				{
					this.cbExpirationDate.Checked = true;
					this.dtpExpirationDate.Value = equipment.MaintenanceContractDate;
				}
				else
				{
					this.cbExpirationDate.Checked = false;
					this.dtpExpirationDate.Value = currentDate.Date.AddHours(23).AddMinutes(59);
				}
				//
				this.cmbManufacturerName.Text = equipment.ManufacturerName;
				this.txtAddressLine1.Text = equipment.ManufacturerAddress.AddressLine1;
				this.txtAddressLine2.Text = equipment.ManufacturerAddress.AddressLine2;
				this.txtCity.Text = equipment.ManufacturerAddress.City;
				this.cmbState.SelectedIndex = this.cmbState.Items.IndexOf(equipment.ManufacturerAddress.StateCode);
				this.mtxtZip.SetText(equipment.ManufacturerAddress.ZipCode);
				this.mtxtPhone.SetText(equipment.ManufacturerPhoneNumber);
				//
				this.btnAdd.Text = "&Update";
				//
				this._equipment.IsDirty = false;
				this._equipment.ManufacturerAddress.IsDirty = false;
				//
				this.CheckValid(sender,e);
			}
			this.SpeakListViewWithCheckBox(lvInventory);
		}

		private void CancelClick(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void OKClick(object sender, System.EventArgs e)
		{
			if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("equipment")) != DialogResult.Yes)
			{
				return;
			}
			//
			ArrayList equipments = new ArrayList(this.lvInventory.CheckedItems.Count);
			foreach(ListViewItem lvi in this.lvInventory.CheckedItems)
			{
				equipments.Add((BOL.Equipment)lvi.Tag);
			}
			//
			try
			{
				if (!BOL.Equipment.InsertEquipment(equipments,Common.UpdateFunction.UC022_FrmNewEquipment))
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.SystemErrorWhileSaving("equipment"));
					return;
				}
				//CR 1441
				System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) Common.WorkloadProcessID.LoginEquipment);
				if(dt!= null)
				{
					if(dt.Rows.Count == 0)
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
					}
				}
			}
			catch(Common.RowVersionException)
			{
				this.btnOK.RowVersionException = true;		//CR2077
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
				return;
			}
			
			//
			this.IsDirty = false;
			//
			this.Close();
		}

		private void lvInventory_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			if (e.NewValue == CheckState.Checked)
			{
				this.btnOK.EnabledButton = true;
			}
			else if ((e.CurrentValue == CheckState.Checked) && (e.NewValue == CheckState.Unchecked) && (this.lvInventory.CheckedItems.Count>1))
			{
				this.btnOK.EnabledButton = true;
			}
			else
			{
				this.btnOK.EnabledButton = false;
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnOK_MouseHover(object sender, System.EventArgs e)
		{
			this.btnOK.SetToolTip( GetOKButtonToolTip() );
		}

		private void btnAddress_Click(object sender, System.EventArgs e)
		{
			//Check if addresses exist on file for manufacturer name
			DataTable addresses = BOL.Equipment.GetManufacturerAddresses(this.cmbManufacturerName.Text.ToUpper());
			//
			if (addresses.Rows.Count>0)
			{
				DlgSelectAddress dlg = new DlgSelectAddress(addresses);
				if (dlg.ShowDialog(this) == DialogResult.OK)
				{
					if (dlg.NewAddress)
					{
						this.txtAddressLine1.Text = "";
						this.txtAddressLine2.Text = "";
						this.txtCity.Text = "";
						this.cmbState.SelectedIndex = -1;
						this.cmbState.Text = "";
						this.mtxtZip.SetText("");
						this.mtxtPhone.SetText("");
					}
					else
					{
						this.txtAddressLine1.Text = dlg.Address.AddressLine1;
						this.txtAddressLine2.Text = dlg.Address.AddressLine2;
						this.txtCity.Text = dlg.Address.City;
						this.cmbState.Text = dlg.Address.StateCode;
						this.mtxtZip.SetText(dlg.Address.ZipCode);
						this.mtxtPhone.SetText(dlg.PhoneNumber);
					}
				}
				this.errError.SetVbecsError(this.mtxtZip, string.Empty); // **** 508 Compliance ***
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC022.NoManufacturerAddresses(this.cmbManufacturerName.Text));
			}
		}

		private void cmbState_Leave(object sender, System.EventArgs e)
		{
			if (this.cmbState.SelectedIndex<0)
			{
				this.cmbState.Text = "";
			}
		}

		private void KeyPressCheckDigit(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			//Restricting to digits and control characters only.
			if (!(char.IsDigit(e.KeyChar)||char.IsControl(e.KeyChar)))
			{
				e.Handled = true;
				return;
			}
			//
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmNewEquipment_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = string.Empty;
			//
			if ( !this.btnAdd.EnabledButton )
			{
				textToSpeak = GetAddButtonToolTip();
			}
			//
			if ( !this.btnOK.EnabledButton )
			{
				textToSpeak = string.Concat(textToSpeak, GetOKButtonToolTip());
			}
			//
			if ( textToSpeak.Length > 0 )
			{
				this.SpeakMessage( textToSpeak );
			}
		}

		#endregion
	}
}

